/*

Schematic View MacroScript File

Created:  		April 1 2003

Author :  Michael Russo
Version:  3ds max 6

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products


--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- 

*/

-- ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
-- Localization Notes
--
-- /* "Localize On" */ states an area where locization should begin
-- /* "Localize Off" */ states an area where locization should end
--
-- *** Localization Note *** states that the next line has special localization instructions for the next line.
-- ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

MacroScript SVAlignLeft
ButtonText:~SVALIGNLEFT_BUTTONTEXT~
Category:~SVALIGNLEFT_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVALIGNLEFT_TOOLTIP~ 
(
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iLeft = pt.x

				-- Loop thru and find left-most node
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.x < iLeft then iLeft = pt.x
				)

				-- Set selection list to left-most value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.x = iLeft
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVAlignRight
ButtonText:~SVALIGNRIGHT_BUTTONTEXT~
Category:~SVALIGNRIGHT_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVALIGNRIGHT_TOOLTIP~ 
(
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iRight = pt.x

				-- Loop thru and find right-most node
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.x > iRight then iRight = pt.x
				)

				-- Set selection list to right-most value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.x = iRight
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVAlignTop
ButtonText:~SVALIGNTOP_BUTTONTEXT~
Category:~SVALIGNTOP_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVALIGNTOP_TOOLTIP~ 
(
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iTop = pt.y

				-- Loop thru and find top-most node
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.y < iTop then iTop = pt.y
				)

				-- Set selection list to top-most value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.y = iTop
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVAlignBottom
ButtonText:~SVALIGNBOTTOM_BUTTONTEXT~
Category:~SVALIGNBOTTOM_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVALIGNBOTTOM_TOOLTIP~ 
(
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iBottom = pt.y

				-- Loop thru and find bottom-most node
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.y > iBottom then iBottom = pt.y
				)

				-- Set selection list to bottom-most value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.y = iBottom
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVAlignVCenter
ButtonText:~SVALIGNVCENTER_BUTTONTEXT~
Category:~SVALIGNVCENTER_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVALIGNVCENTER_TOOLTIP~ 
(
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (
			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iTop = pt.y
				local iBottom = pt.y

				-- Loop thru and find top and bottom-most values
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.y > iBottom then iBottom = pt.y
					if pt.y < iTop then iTop = pt.y
				)

				-- Set selection list to centered value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.y = (iTop + iBottom) / 2
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVAlignHCenter
ButtonText:~SVALIGNHCENTER_BUTTONTEXT~
Category:~SVALIGNHCENTER_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVALIGNHCENTER_TOOLTIP~ 
(
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 1 do (

				-- Get first entry in selection list
				local pt = sv.getSVNodePos selList[1]
				local iLeft = pt.x
				local iRight = pt.x

				-- Loop thru and find left and right-most values
				for i in selList do (
					pt = sv.getSVNodePos i
					if pt.x > iRight then iRight = pt.x
					if pt.x < iLeft then iLeft = pt.x
				)

				-- Set selection list to centered value
				for i in selList do (
					pt = sv.getSVNodePos i
					pt.x = (iLeft + iRight) / 2
					sv.setSVNodePos i sv.moveChildren pt
				)
			)

			-- End SV edit session
			sv.endEdit()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.alwaysarrange != true
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVParamWire
ButtonText:~SVPARAMWIRE_BUTTONTEXT~
Category:~SVPARAMWIRE_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVPARAMWIRE_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do sv.setMode #PARAMWIRE
	)
)


MacroScript SVAlwaysArrange
ButtonText:~SVALWAYSARRANGE_BUTTONTEXT~
Category:~SVALWAYSARRANGE_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVALWAYSARRANGE_TOOLTIP~ 
(
	on execute do
	(
		if( schematicviews.current!=undefined ) do
			schematicviews.current.alwaysarrange = not schematicviews.current.alwaysarrange
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) then true
		else not schematicviews.current.TestIncludeFilter #selectedOnly
	)

	on isVisible do return (schematicViews.current!=undefined)
	on isChecked do
	(
		if( schematicviews.current==undefined ) then false
		else schematicviews.current.alwaysarrange
	)
)

MacroScript SVSyncSelection
ButtonText:~SVSYNCSELECTION_BUTTONTEXT~
Category:~SVSYNCSELECTION_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVSYNCSELECTION_TOOLTIP~ 
(
	on execute do
	(
		if( schematicviews.current!=undefined ) do
		(
			schematicviews.current.syncSelection = not schematicviews.current.syncSelection
		)
	)

	on isVisible do return (schematicViews.current!=undefined)
	on isChecked do
	(
		if( schematicviews.current==undefined ) then false
		else schematicviews.current.syncSelection
	)
)


MacroScript SVUnShrinkAll
ButtonText:~SVUNSHRINKALL_BUTTONTEXT~
Category:~SVUNSHRINKALL_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVUNSHRINKALL_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		if( schematicviews.current!=undefined ) do (
			schematicviews.current.unShrinkAll()
			schematicviews.current.updateView false
		)
	)
)


MacroScript SVShrinkSelected
ButtonText:~SVSHRINKSELECTED_BUTTONTEXT~
Category:~SVSHRINKSELECTED_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVSHRINKSELECTED_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()
			
			sv.shrink()

			-- End SV edit session
			sv.endEdit()
			
			sv.updateView false
		)
	)
)

MacroScript SVUnShrinkSelected
ButtonText:~SVUNSHRINKSELECTED_BUTTONTEXT~
Category:~SVUNSHRINKSELECTED_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVUNSHRINKSELECTED_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			sv.unshrink()

			-- End SV edit session
			sv.endEdit()
			
			sv.updateView false
		)
	)
)

MacroScript SVArrangeSelected
ButtonText:~SVARRANGESELECTED_BUTTONTEXT~
Category:~SVARRANGESELECTED_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVARRANGESELECTED_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local selList = sv.getSelectedSVNodes()

			if selList.count > 0 do (
				sv.arrangeSVNode()
			)

			-- End SV edit session
			sv.endEdit()
			
			sv.updateView false
		)
	)
)

MacroScript SVAssignController
ButtonText:~SVASSIGNCONTROLLER_BUTTONTEXT~
Category:~SVASSIGNCONTROLLER_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVASSIGNCONTROLLER_TOOLTIP~ 
(
	on execute do
	(
		if( schematicviews.current!=undefined ) then
		(
			schematicviews.current.ShowAssignControllerDialog()
		)
	)

	on isEnabled do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.canAssignController()
	)
	on isVisible do return (schematicViews.current!=undefined)
)

MacroScript SVDeleteSelected
ButtonText:~SVDELETESELECTED_BUTTONTEXT~
Category:~SVDELETESELECTED_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVDELETESELECTED_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.DeleteSelected()
	)
)

MacroScript SVRefresh
ButtonText:~SVREFRESH_BUTTONTEXT~
Category:~SVREFRESH_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVREFRESH_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.updateView true
	)
)

MacroScript SVShowPreferenceDialog
ButtonText:~SVSHOWPREFERENCEDIALOG_BUTTONTEXT~
Category:~SVSHOWPREFERENCEDIALOG_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVSHOWPREFERENCEDIALOG_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.ShowPreferencesDialog()
	)
)

MacroScript SVShowDisplayFloater
ButtonText:~SVSHOWDISPLAYFLOATER_BUTTONTEXT~
Category:~SVSHOWDISPLAYFLOATER_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVSHOWDISPLAYFLOATER_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.ShowDisplayFloater true
	)
)

MacroScript SVShowRelDialogSelected
ButtonText:~SVSHOWRELDIALOGSELECTED_BUTTONTEXT~
Category:~SVSHOWRELDIALOGSELECTED_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVSHOWRELDIALOGSELECTED_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.ShowRelationshipDialog false
	)
)

MacroScript SVShowRelDialogAll
ButtonText:~SVSHOWRELDIALOGALL_BUTTONTEXT~
Category:~SVSHOWRELDIALOGALL_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVSHOWRELDIALOGALL_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		if( schematicviews.current==undefined ) then true
		else schematicviews.current.ShowRelationshipDialog true
	)
)

MacroScript SVShowAnimatedControllers
ButtonText:~SVSHOWANIMATEDCONTROLLERS_BUTTONTEXT~
Category:~SVSHOWANIMATEDCONTROLLERS_CATEGORY~ 
internalCategory:"Schematic View" 
Tooltip:~SVSHOWANIMATEDCONTROLLERS_TOOLTIP~ 
(
	on isVisible do return (schematicViews.current!=undefined)
	on execute do
	(
		-- Get current schematic view interface
		local sv = schematicViews.current

		if sv != undefined do (

			-- Begin SV edit session
			sv.beginEdit()

			-- Get list of selected SV Nodes
			local numNodes = sv.getNumSVNodes()

			local animCtrls = #()

			for i = 0 to numNodes-1 do
			(
				if sv.testSVNodeState i #animated do append animCtrls i				
			)

			sv.ShowListViewdialog animCtrls title:~ANIMCTRLS_TITLE~ id:50

			-- End SV edit session
			sv.endEdit()
		)
	)
)


